function Figure56(in, phase)

%% Phases
visNumberOfGapAcceptancePhasesAll(in.phasesSum, phase.borders);
end

function visNumberOfGapAcceptancePhases(data, border, con, mapping)
fld_con = fieldnames(data);
c = find(strcmp(fld_con,con));
fld_map = fieldnames(data.(fld_con{c}));
m = find(strcmp(fld_map,mapping));
fld_phase = fieldnames(data.(fld_con{c}).(fld_map{m}));
nrPhases = length(fld_phase);

% Phase sizes
t = zeros(nrPhases+1,1);
for i=1:nrPhases
    if i == 1
        t(i+1) = length(data.(fld_con{c}).(fld_map{m}).(fld_phase{i}));
    else
        t(i+1) = t(i) + length(data.(fld_con{c}).(fld_map{m}).(fld_phase{i}));
    end
end

% Draw
hold on
for i=1:nrPhases
    % Rectangle
    if (strcmp(con,'D_Y')||strcmp(con,'ND_Y')) && strcmp(mapping,'map0')
        rectpos = [border.(fld_con{c}).(fld_map{m}).rect(i,1), -5, border.(fld_con{c}).(fld_map{m}).rect(i,3), 110];
        rectangle('Position',rectpos,'FaceColor',[0.9-i/10 0.9-i/10 0.9-i/10 0.4],'EdgeColor',[0 0 0]);
        text(border.(fld_con{c}).(fld_map{m}).midx(i), 105,['(',num2str(i),')'],'HorizontalAlignment','center','VerticalAlignment', 'top','FontSize',25);
    end
    grid on
    ax=gca; ax.FontSize = 25;
    xlabel('Time (s)','FontSize',25,'FontWeight','bold');
    ylabel({'Crossing button press (% of trials)'},'FontSize',25,'FontWeight','bold');
    ylim([-5 105]);
    xlim([0, border.(fld_con{1}).(fld_map{2}).rect(end,1)+border.(fld_con{1}).(fld_map{1}).rect(end,3)]);
    set(gca,'LooseInset',[0.01 0.01 0.01 0.01])
end

for i=1:nrPhases
    plotdata = data.(fld_con{c}).(fld_map{m}).(fld_phase{i});
    switch m
        case 1
            colour = [0, 0.45, 0.74];
        case 2
           colour = [0.85, 0.33, 0.10];
        case 3
            colour = [0.93, 0.69, 0.13];
    end
    if ismember(c,[1 3])
            linestyle = '-';
    else
        linestyle = '--';
    end
 
    a = plot((t(i)+1:t(i+1))*0.0167,plotdata,linestyle,'Color', colour,'LineWidth',2);
   
    if(i>1)
        set(get(get(a,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
    end
end
end

function visNumberOfGapAcceptancePhasesAll(data, border)
fld_con = fieldnames(data);
for c=[1,3]
    fld_map = fieldnames(data.(fld_con{c}));
    figure;
    for m=1:length(fld_map)
        visNumberOfGapAcceptancePhases(data, border, fld_con{c}, fld_map{m});
    end
    for m=1:length(fld_map)
        visNumberOfGapAcceptancePhases(data, border, fld_con{c+1}, fld_map{m});
    end
    legend('Baseline - Yielding','LTY - Yielding','LATY - Yielding','Baseline - Non-yielding','LTY - Non-yielding','LATY - Non-yielding','location','southeast')
end
end
